/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.file;

import com.quantumdata.fmteditor.FmtEditorMain;
import com.quantumdata.fmteditor.InstrumentSource;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.file.FileSelectDlg;
import com.quantumdata.fmteditor.fmtwidgets.FmtFrameBase;
import java.io.File;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public abstract class LoaderSaver
extends Thread {
    protected boolean m_isActive = false;
    protected boolean m_isLoad = true;
    protected boolean m_isLocal = true;
    protected InstrumentSource m_isrc = null;
    protected boolean m_success = false;
    protected String m_errMsg = null;
    protected String m_fileName = "";
    protected File m_file = null;
    protected FmtFrameBase m_frame = null;
    protected boolean m_disposeOnSave = false;

    public void open(FileSelectDlg fileSelectDlg, InstrumentSource instrumentSource) {
        this.m_isrc = instrumentSource;
        this.m_isLoad = true;
        this.m_isLocal = fileSelectDlg.wasLocalChoosen();
        if (this.m_isLocal) {
            this.m_file = fileSelectDlg.getLocalFile();
            this.m_fileName = this.m_file.getAbsolutePath();
        } else {
            this.m_fileName = fileSelectDlg.getRemoteFileName();
            this.m_file = new File(this.m_fileName);
        }
    }

    public void save(FileSelectDlg fileSelectDlg, FmtFrameBase fmtFrameBase, boolean bl) {
        this.m_frame = fmtFrameBase;
        this.m_isrc = fmtFrameBase;
        this.m_disposeOnSave = bl;
        this.m_isLoad = false;
        this.m_isLocal = fileSelectDlg.wasLocalChoosen();
        if (this.m_isLocal) {
            this.m_file = fileSelectDlg.getLocalFile();
            this.m_fileName = this.m_file.getAbsolutePath();
        } else {
            this.m_fileName = fileSelectDlg.getRemoteFileName();
            this.m_file = new File(this.m_fileName);
        }
    }

    public void run() {
        this.m_isActive = true;
        this.m_success = false;
        if (this.m_isLoad) {
            if (this.m_isLocal) {
                this.localLoad();
            } else {
                this.remoteLoad();
            }
        } else if (this.m_isLocal) {
            this.localSave();
        } else {
            this.remoteSave();
        }
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    protected void callLoadComplete() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LoaderSaver.this.loadComplete();
            }
        });
    }

    protected void callSaveComplete() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LoaderSaver.this.saveComplete();
            }
        });
    }

    public boolean checkAndSelectIfOpen(String string) {
        JInternalFrame[] jInternalFrameArray;
        FmtEditorMain fmtEditorMain = FmtEditorMain.instance();
        for (JInternalFrame jInternalFrame : jInternalFrameArray = fmtEditorMain.getDesktop().getAllFrames()) {
            FmtFrameBase fmtFrameBase = (FmtFrameBase)((Object)jInternalFrame);
            if (!fmtFrameBase.isSaveable() || !string.equalsIgnoreCase(fmtFrameBase.getDataName())) continue;
            fmtEditorMain.getWindowMenu().selectFrame(fmtFrameBase);
            return true;
        }
        return false;
    }

    protected abstract void localLoad();

    protected abstract void localSave();

    protected abstract void remoteLoad();

    protected abstract void remoteSave();

    protected void loadComplete() {
        FmtEditorMain fmtEditorMain = FmtEditorMain.instance();
        fmtEditorMain.getStatusPanel().hideProgress();
        if (this.m_success) {
            fmtEditorMain.addFrame(this.m_frame);
            MsgLog.msg("Opened: " + this.m_frame.getTitle());
        } else if (this.m_errMsg != null) {
            MsgLog.error(this.m_errMsg);
        }
        this.m_isActive = false;
    }

    protected void saveComplete() {
        FmtEditorMain fmtEditorMain = FmtEditorMain.instance();
        if (this.m_frame != null) {
            if (this.m_success) {
                this.m_frame.setFrameTitle();
                MsgLog.msg("Saved: " + this.m_frame.getTitle());
            }
            if (this.m_disposeOnSave) {
                this.m_frame.dispose();
            } else {
                fmtEditorMain.getWindowMenu().updateFrame(this.m_frame);
            }
        }
        fmtEditorMain.getStatusPanel().hideProgress();
        this.m_isActive = false;
    }

    protected String swapExtension(String string, String string2, String string3) {
        if (string.toLowerCase().endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
        }
        if (!string.toLowerCase().endsWith(string3)) {
            string = string + string3;
        }
        return string;
    }
}

